using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using System.Web.Security;
using System.Globalization;
using Microsoft.VisualBasic;
namespace CoilCenter3FZ.SaleProgram
{
	/// <summary>
	/// Summary description for CSFZ21_1.
	/// </summary>
	public class CSFZ21_1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label lblNo;
		protected System.Web.UI.WebControls.Label lblQty;
		protected System.Web.UI.WebControls.Button btnClear;
		protected System.Web.UI.WebControls.Button btnUpdate;
		protected System.Web.UI.WebControls.Button btnSave;
		protected System.Web.UI.WebControls.TextBox txtRemark;
		protected System.Web.UI.WebControls.Label lbAddress2;
		protected System.Web.UI.WebControls.Label lbAddress1;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator5;
		protected System.Web.UI.WebControls.Label lblCustName;
		protected System.Web.UI.WebControls.TextBox txtCustcode;
		protected System.Web.UI.WebControls.CheckBox chConsign;
		protected System.Web.UI.WebControls.Label WarningLbl;
		protected System.Web.UI.WebControls.Button Logout_Btn;
		protected System.Web.UI.WebControls.Button Button2;
		protected System.Web.UI.WebControls.HyperLink Print_Lnk;
		protected System.Web.UI.HtmlControls.HtmlInputHidden ScrollPOS;
		protected System.Web.UI.HtmlControls.HtmlForm Form1;
		protected System.Web.UI.WebControls.RadioButtonList rdbType;
		protected System.Web.UI.WebControls.TextBox txtDONo;
		protected System.Web.UI.WebControls.TextBox txtContractNo;
		protected System.Web.UI.WebControls.TextBox txtOrderNo;
		protected System.Web.UI.WebControls.RequiredFieldValidator Requiredfieldvalidator7;
		protected System.Web.UI.WebControls.TextBox txtDueDate;
		protected System.Web.UI.WebControls.DataGrid dgPacklist;
		protected System.Web.UI.WebControls.TextBox txtGrossWeight;
		protected System.Web.UI.WebControls.TextBox Textbox3;
		protected System.Web.UI.WebControls.DropDownList ddlYear;
		protected System.Web.UI.WebControls.DropDownList ddlMonth;
		protected System.Web.UI.WebControls.Button btnsearch;
		protected System.Web.UI.WebControls.Button btnAdd;
		protected System.Web.UI.WebControls.TextBox txtTerm;
		protected System.Web.UI.WebControls.DropDownList ddlComm;
		protected System.Web.UI.WebControls.DataGrid Datagrid1;
		protected System.Web.UI.WebControls.DataGrid dgSearch;
		protected System.Web.UI.HtmlControls.HtmlInputHidden HidWarning;
		protected System.Data.SqlClient.SqlConnection sqlconn;
		protected System.Web.UI.WebControls.TextBox txttotalWeight;
		protected System.Web.UI.WebControls.TextBox txtAdjust;
		protected System.Web.UI.WebControls.TextBox txtNetWeight;
		protected System.Web.UI.WebControls.Label lblTotalWeight;
		protected System.Web.UI.WebControls.HyperLink HyperLink1;
		protected System.Web.UI.WebControls.TextBox LotTbx;
		protected System.Web.UI.WebControls.Button btnPrint;
		protected System.Web.UI.WebControls.Button btnPrint2;
		protected System.Web.UI.WebControls.RadioButtonList rblOrderType;
		protected System.Web.UI.WebControls.Button btnSumWt;
		protected System.Web.UI.WebControls.Label lblSumWt;
		protected System.Web.UI.WebControls.DropDownList ddlGroupNo;
		protected System.Web.UI.WebControls.RadioButtonList rblFilterType;
		protected UserControl.DatePicker.DatePickerICO DPIDate;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			sqlconn.ConnectionString = Global.ConnectionStr();	// Connection String
			//Response.Write(Session["MenuContent2"].ToString());
			//if(!this.IsStartupScriptRegistered("MenuScript"))	// Past Menu
			//	RegisterStartupScript("MenuScript", Session["MenuScript"].ToString());

			// Javascript Warning Control
			PrepareWarningScript();	

			// Clear Form
			this.WarningLbl.Text = "";

			if (!IsPostBack)
			{//first
				if (Request.QueryString["detail"] == "Y")
				{
					BindGrid();
					this.txtCustcode.Text =Utility_Function.chkDBNull(Session["cust_code"]);
					this.lblCustName.Text =Utility_Function.chkDBNull(Session["cust_name"]);
					this.lbAddress1.Text  =Utility_Function.chkDBNull(Session["address1"]);
					this.lbAddress2.Text  =Utility_Function.chkDBNull(Session["address2"]);
					this.txtTerm.Text   =Utility_Function.chkDBNull(Session["term"]);
					this.txtContractNo.Text = Utility_Function.chkDBNull(Session["Contract"]);
					this.DPIDate.DateText= Utility_Function.chkDBNull(Session["date"]);
					this.txtDueDate.Text =Utility_Function.chkDBNull(Session["duedate"]);
					int type =Convert.ToInt16(Utility_Function.chkDBNull(Session["type"]));
					this.rdbType.ClearSelection();
					this.rdbType.Items[type].Selected = true;
					//-----SQL007-----
					sql = " Select cm.comm_id, cm.comm_desc "
						+ " From CS_Commodity cm, CS_Customer c "
						+ " Where cm.cust_code = c.cust_code "
						+ " And cm.status = 'Y' "
						+ " And cm.cust_code = '" + this.txtCustcode.Text + "'"
						+ " Order By cm.comm_desc ";
					Utility_Function.DDLBind(this.ddlComm,sql,"comm_desc","comm_id","--Select a commodity--","NULL",
						Utility_Function.chkDBNull_ReturnNull(Utility_Function.chkDBNull(Session["ddlcomm"])));
					setDDLDate(true);
					Session["again"]= "N";
					ClearSearch(); //SearchPack_Math(false);
					this.btnSave.Enabled = true;
					this.btnUpdate.Enabled= false;
				}	
				else
					SetClearPage(true);
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			this.DPIDate.onShowCalendar += new System.EventHandler(this.DPIDate_onShowCalendar);
			this.DPIDate.onHideCalendar += new System.EventHandler(this.DPIDate_onHideCalendar);
			this.DPIDate.DateChanged += new System.EventHandler(this.DPIDate_DateChanged);
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.sqlconn = new System.Data.SqlClient.SqlConnection();
			this.Logout_Btn.Click += new System.EventHandler(this.Logout_Btn_Click);
			this.rdbType.SelectedIndexChanged += new System.EventHandler(this.rdbType_SelectedIndexChanged);
			this.txtDONo.TextChanged += new System.EventHandler(this.txtDONo_TextChanged);
			this.chConsign.CheckedChanged += new System.EventHandler(this.chConsign_CheckedChanged);
			this.txtCustcode.TextChanged += new System.EventHandler(this.txtCustcode_TextChanged);
			this.ddlComm.SelectedIndexChanged += new System.EventHandler(this.ddlComm_SelectedIndexChanged);
			this.dgPacklist.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DeleteItem);
			this.dgPacklist.ItemDataBound += new System.Web.UI.WebControls.DataGridItemEventHandler(this.dgPacklist_ItemDataBound);
			this.txtNetWeight.TextChanged += new System.EventHandler(this.txtNetWeight_TextChanged);
			this.txtGrossWeight.TextChanged += new System.EventHandler(this.txtGrossWeight_TextChanged);
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
			this.btnPrint2.Click += new System.EventHandler(this.btnPrint2_Click);
			this.btnsearch.Click += new System.EventHandler(this.btnsearch_Click);
			this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
			this.btnSumWt.Click += new System.EventHandler(this.btnSumWt_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		#region Define valiable
		//Define Use Class Here
		private MSSQL_Function MSSQL_Function = new MSSQL_Function();
		private GUI_Function GUI_Function = new GUI_Function();
		private Utility_Function Utility_Function = new Utility_Function();
		private Date_Function Date_Function = new  Date_Function();
		//
		private const int MAX_DATAGRID_ROW = 12;
		private const int BACKYEAR = 5;
		private string sql;
		private enum myDGColumn 
		{
			No = 0, P_MNo= 1, Spec = 2, Size = 3, Qty = 4, Weight = 5,WH = 6,ST=7,del=8,status= 9
		}

		double TotalWt;
		double TotalQty;

		#endregion

		#region JavaScript
		private void PrepareWarningScript()
		{
			string sJavaScript = "<script language=javascript >";
			sJavaScript += "function PrepareWarningScript() {";
			sJavaScript += "	var ButtonClick;";
			sJavaScript += "	switch (Form1.HidWarning.value)";
			sJavaScript += "	{";
			sJavaScript += "		case \"_DoNothing\" :";
			sJavaScript += "			break;";
			sJavaScript += "		case \"\" :";
			sJavaScript += "			break;";
			sJavaScript += "		case \"CANCELBTN_CLICK\" :";
			/*check*/	sJavaScript += "			ButtonClick = window.confirm('سͧ¡ԡ[' + Form1.txtDONo.value + '] ?');";
			sJavaScript += "			if ( ButtonClick ) {";
			sJavaScript += "				Form1.HidWarning.value = 'CANCELBTN_CLICK_OK';";
			sJavaScript += "				Form1.submit();";
			sJavaScript += "			}";
			sJavaScript += "			else {";
			sJavaScript += "				Form1.HidWarning.value = '';";
			sJavaScript += "			}";
			sJavaScript += "			break;";
			sJavaScript += "		case \"DELBTN_CLICK\" :";
			/*check*/	sJavaScript += "			ButtonClick = window.confirm('سͧź[' + Form1.Hidpack.value + '] ?');";
			sJavaScript += "			if ( ButtonClick ) {";
			sJavaScript += "				Form1.HidWarning.value = 'DELBTN_CLICK_OK';";
			sJavaScript += "				Form1.submit();";
			sJavaScript += "			}";
			sJavaScript += "			else {";
			sJavaScript += "				Form1.HidWarning.value = '';";
			sJavaScript += "			}";
			sJavaScript += "			break;";sJavaScript += "		case \"SAVEBTN_COMPLETE\":";
			sJavaScript += "			alert(\"ѹ֡º\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"SAVEBTN_ERROR\":";
			sJavaScript += "			alert(\"SAVE ERROR\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"CANCELBTN_COMPLETE\":";
			sJavaScript += "			alert(\"¡ԡº\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_DATALOCKED\":";
			sJavaScript += "			alert(\"͹١͡ ö¹ŧ\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_INVALIDDATE\":";
			sJavaScript += "			alert(\"سҡ͡ѹ١ٻẺ (dd/mm/yyyy)\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_REQUIREDATE\":";
			sJavaScript += "			alert(\"سҡ͡ѹ\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_REQUIREPACK\":";
			sJavaScript += "			alert(\"سҡ͡ Pack-No 㹵ҧ\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_DATAEXIST\":";
			sJavaScript += "			alert(\"Ţ Packing-No к\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_NOTFOUND\":";
			sJavaScript += "			alert(\"辺\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		default :";
			sJavaScript += "			alert(Form1.HidWarning.value);";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "	}";
			sJavaScript += "}";
			sJavaScript += "addEvent(window, 'load', new Function('PrepareWarningScript()'));";
			sJavaScript += "</script>";
			if (!IsClientScriptBlockRegistered("PrepareWarningScript")) 
				this.RegisterClientScriptBlock("PrepareWarningScript", sJavaScript);
		}

		private void Alert(string text)
		{
			string alert = 
				" <SCRIPT language='javascript'>"
				+ "  alert('" + text + "');"
				+ " </SCRIPT>";
			RegisterStartupScript("warning",alert);	  
		}
		public void UnLockLocation()
		{
			string vScript  = 
				"<SCRIPT language='javascript'>Form1.ScrollPOS.value = document.body.scrollTop;</SCRIPT>";
			RegisterStartupScript("unlock",vScript);	  
			
		}
		#endregion

		#region Clear and initial 

		private void SetClearPage(bool setrdb)
		{
			if (setrdb)
			{
				this.rdbType.ClearSelection();
				this.rdbType.Items[0].Selected = true;	
				Session["type"]= 0;
			}
			this.txtDONo.Text = "";
			Session["term"]= this.txtTerm.Text = "0";
			this.DPIDate.SetToNow();
			Session["date"]= this.DPIDate.DateText;
			this.chConsign.Checked = false;
			Session["Contract"]= this.txtContractNo.Text = "";
			this.txtOrderNo.Text = "";
			CalDueDate(false);
//			//-----SQL007-----
//			sql = " Select cm.comm_id, cm.comm_desc "
//				+ " From CS_Commodity cm, CS_Customer c "
//				+ " Where cm.cust_code = c.cust_code "
//				+ " And cm.status = 'Y' "
//				+ " And cm.cust_code = '" + this.txtCustcode.Text + "'"
//				+ " Order By cm.comm_desc ";
//			Utility_Function.DDLBind(this.ddlComm,sql,"comm_desc","comm_id","--Select a commodity--","NULL","");
			this.ddlComm.Items.Clear();
			Session["ddlcomm"] = "NULL";
			this.chConsign.Checked = false;
			Session["cust_code"] = this.txtCustcode.Text = "";
			Session["cust_name"]= this.lblCustName.Text = "";
			Session["address1"]= this.lbAddress1.Text = "";
			Session["address2"]= this.lbAddress2.Text= "";
			this.LotTbx.Text = "";
			this.ddlGroupNo.SelectedIndex = 0;
			this.txttotalWeight.Text="";
			this.txtGrossWeight.Text = "";
			this.txtNetWeight.Text= "";
			this.txtAdjust.Text= "";
			this.txtRemark.Text = "";
			this.btnSave.Enabled = true;
			this.btnUpdate.Enabled= false;
			setDDLDate(false);
			setToUpdate(true);
			BindGrid();
			GUI_Function.SetFocus(this.txtDONo);
			Session["again"]= "N";

		}
		private DataTable CreateStructDT()
		{
			DataTable dt = new DataTable();
			//dt.Columns.Add ("Select");
			dt.Columns.Add ("No");
			dt.Columns.Add ("pack_no");
			dt.Columns.Add ("mat_spec" );
			dt.Columns.Add ("size" );
			dt.Columns.Add ("qty" );
			dt.Columns.Add ("wt" );
			dt.Columns.Add ("wh_code" );
			dt.Columns.Add ("st_area" );
			dt.Columns.Add ("status");//1=new(not save), 2= save
			return dt;
		}
		private void setClearCust()
		{
			this.txtCustcode.Text = "";
			this.lbAddress1.Text = "";
			this.lbAddress2.Text = "";
			this.txtTerm.Text = "0";
			this.lblCustName.Text = "";
		}

		private void setDDLDate(bool setselect)
		{
			this.ddlMonth.Items.Clear();
			DateTimeFormatInfo info = new DateTimeFormatInfo();
			string[] monthname = info.MonthNames;
			for (int i = 0; i < 12; i++)
			{
				string monthNo  =string.Format("{0:0#}",i+1);
				string monthDetail = monthNo + "-" + monthname[i];
				ddlMonth.Items.Add(new ListItem(monthDetail,monthNo));
			}   
			this.ddlYear.Items.Clear();
			for (int i = 0; i < BACKYEAR; i++)
			{
				string years = DateTime.Now.AddYears(0-i).Year.ToString();
				ddlYear.Items.Add(new ListItem(years,years));

			}
			if (setselect)
			{
				string month = Utility_Function.chkDBNull(Session["month"]);
				this.ddlMonth.SelectedValue = month;
				string year = Utility_Function.chkDBNull(Session["year"]);
				this.ddlYear.SelectedValue = year;
			}
			else
			{
				ddlYear.Items[0].Selected = true;
				ddlMonth.Items[0].Selected = true;
				Session["year"] = this.ddlYear.SelectedValue;
				Session["month"] = this.ddlMonth.SelectedValue;

			}
		}

		private bool CheckListCommodityDdl(string CustCode) 
		{
			if (CustCode == "") return false;
			//-----SQL007-----
			sql = " Select cm.comm_id, cm.comm_desc "
				+ " From CS_Commodity cm, CS_Customer c "
				+ " Where cm.cust_code = c.cust_code "
				+ " And cm.status = 'Y' "
				+ " And cm.cust_code = '" + CustCode + "'"
				+ " Order By cm.comm_desc ";
			Utility_Function.DDLBind(this.ddlComm,sql,"comm_desc","comm_id","--Select a commodity--","NULL","");
			if (this.ddlComm.Items.Count == 1) 
			{
				this.HidWarning.Value = "١ "+this.txtCustcode.Text+" ѧ Commodity \n ôѹ֡ŷ RF002 ͹";
				setButton(false,false);
				return false;
			}
			else
				return true;
		}

		#endregion

		#region Set and bind data 
		private void BindGrid()
		{
			this.lblTotalWeight.Text = "0";
			this.lblQty.Text = "0";
			DataTable dt = CreateStructDT();
			dgSearch.DataSource = dt.DefaultView ;
			dgSearch.DataBind();
			this.lblSumWt.Text = "0 KGS.";
			
			Session["dt"]= dt; 
			this.lblTotalWeight.Text = "0";
			this.lblQty.Text = "0";
			dgPacklist.DataSource = dt.DefaultView;
			dgPacklist.DataBind();

			for (int i = 0; i < dgSearch.Items.Count; i++)
			{
				CheckBox ch = new CheckBox();
				ch = (CheckBox) dgSearch.Items[i].Cells[(int) myDGColumn.No].Controls[1];
				ch.Enabled= false;
			}
		}

		// Newly add by ammer
		private void ClearSearch() 
		{
			DataTable dt = CreateStructDT();
			dgSearch.DataSource = dt.DefaultView ;
			dgSearch.DataBind();
			this.lblSumWt.Text = "0 KGS.";
		}

		private void QueryCustCode()
		{
			CTSQL ct = new CTSQL();
			string custcode = this.txtCustcode.Text ;
			sqlconn.Open();
			SqlDataReader r = ct.Get_Customer (this.txtCustcode.Text  , sqlconn);
			if(r.Read())
			{//cust_name, Customer P/O, address1, address2, Term
				Session["cust_code"] = this.txtCustcode.Text = r["cust_code"].ToString();
				Session["cust_name"] = this.lblCustName.Text = r["cust_name"].ToString();
				Session["address1"] =this.lbAddress1.Text  = r["address1"].ToString();
				Session["address2"] = this.lbAddress2.Text  = r["address2"].ToString();
				Session["term"] =this.txtTerm.Text   = r["credit"].ToString();
				Session["Contract"] =this.txtContractNo.Text ;
				CalDueDate(false);
				this.WarningLbl.Text = "";
				setButton(true,false);
			}
			else
			{
				setClearCust();
				this.HidWarning.Value = "辺 Cust code " + custcode;
				GUI_Function.SetFocus(this.txtCustcode );
				setButton(true,false);
				this.ddlComm.Items.Clear();
			}
			sqlconn.Close(); 
			//BindGrid();
		}
		#endregion

		#region Datagrid
		public void SearchHeaderCheck_Clicked(object sender,EventArgs e) 
		{
			CheckBox chkhead = (CheckBox) sender;
			CheckBox chk;
			DataGridItem item;

			for (int i=0 ; i<dgSearch.Items.Count ; ++i)
			{
				item = dgSearch.Items[i];
				chk = (CheckBox) item.Cells[0].Controls[1];
				if (chk.Enabled)
				{
					chk.Checked = chkhead.Checked;
				}
			}
		}

		private void dgPacklist_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			string strQty;
			string strWt;
			if ( e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
			{
				TextBox qty = (TextBox) e.Item.Cells[(int) myDGColumn.Qty].Controls[1];
				TextBox wt = (TextBox) e.Item.Cells[(int) myDGColumn.Weight].Controls[1];
				if ( qty.Text.Trim() == "" ) 
					strQty = "0";
				else
					strQty = qty.Text.Trim();

				if ( wt.Text.Trim() == "" ) 
					strWt = "0";
				else
					strWt = wt.Text.Trim();
				
				TotalQty = Double.Parse(this.lblQty.Text);
				TotalQty += Double.Parse(strQty);
				this.lblQty.Text = TotalQty.ToString();  

				TotalWt =Double.Parse(this.lblTotalWeight.Text);
				TotalWt += Double.Parse(strWt);
				this.lblTotalWeight.Text = TotalWt.ToString();

			}
			else if( e.Item.ItemType == ListItemType.Footer)
			{
				((Label) e.Item.Cells[(int) myDGColumn.Qty].Controls[1]).Text = string.Format("{0:n}",TotalQty);
				((Label) e.Item.Cells[(int) myDGColumn.Weight].Controls[1]).Text = string.Format("{0:n}", TotalWt);
				this.txttotalWeight.Text =  TotalWt.ToString();
			}
			else if (e.Item.ItemType == ListItemType.Header)
			{
				if (this.btnSave.Enabled)
					e.Item.Cells[(int) myDGColumn.del].Text = "<FONT color='#6666FF'><A href='../SaleProgram/CSFZ21-1.aspx?detail=Y'>DEL ALL</A></FONT>";
					//e.Item.Cells[(int) myDGColumn.del].Enabled = true; // = "DEL ALL";		
				else
					e.Item.Cells[(int) myDGColumn.del].Text  = "DEL ALL";
			}
		}
		public void DeleteItem(object sender,System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			if (e.Item.ItemType == ListItemType.Header)
			{
				BindGrid();
			}
			else
			{
				TextBox P_MNo = (TextBox) e.Item.Cells[(int) myDGColumn.P_MNo].Controls[1];
				string status = e.Item.Cells[(int) myDGColumn.status].Text;
				if (P_MNo.Text != "")
				{
					if (status.Trim() == "2")
						this.HidWarning.Value = "öź" + P_MNo.Text + "աúѹ֡" ;
					else
					{
						DataTable dt = (DataTable)Session["dt"];	
						DataTable dtclone = dt.Clone();
						int no = 1;
						for (int i = 0; i < dt.Rows.Count; i++)
						{
							if (dt.Rows[i]["pack_no"].ToString() != P_MNo.Text)
							{
								DataRow dr = dtclone.NewRow();
								dr["No"] = no;
								no = no + 1;
								dr["pack_no"] = dt.Rows[i]["pack_no"].ToString();
								dr["mat_spec"]= dt.Rows[i]["mat_spec"].ToString();
								if (Utility_Function.chkDBNull(dt.Rows[i]["size"].ToString())== "")
									dr["size"]= System.DBNull.Value;
								else	
									dr["size"]= dt.Rows[i]["size"].ToString();
								if (Utility_Function.chkDBNull(dt.Rows[i]["qty"].ToString())== "")
									dr["qty"]= System.DBNull.Value;
								else	
									dr["qty"]= dt.Rows[i]["qty"].ToString();
								if (Utility_Function.chkDBNull(dt.Rows[i]["wt"].ToString())== "")
									dr["wt"]= System.DBNull.Value;
								else							
									dr["wt"]= dt.Rows[i]["wt"].ToString();
								dr["wh_code"]= Utility_Function.chkDBNull(dt.Rows[i]["wh_code"].ToString());
								dr["st_area"]= Utility_Function.chkDBNull(dt.Rows[i]["st_area"].ToString());
								dr["status"]= dt.Rows[i]["status"].ToString();
								dtclone.Rows.Add (dr);
							}
						}//end for	
						this.lblTotalWeight.Text = "0";
						this.lblQty.Text = "0";
						Session["dt"]= dtclone;
						this.dgPacklist.DataSource = dtclone;
						this.dgPacklist.DataBind();
					}//if (status.Trim() != "2")
				}//if (P_MNo.Text != "")
			}
		}

		#endregion

		#region Search data about package/math no
		private void SearchPack_Math(bool msg)
		{
			string consign;
			if (this.chConsign.Checked) 
				consign = "*";
			else
				consign = "";
			string pl_type =this.rdbType.SelectedValue.ToString();
			string order_type = this.rblOrderType.SelectedValue.ToString();
			string filter_type = this.rblFilterType.SelectedValue.ToString();

			switch (Convert.ToInt16(pl_type)) 
			{// query add '1' status**********
				case 4:// COVER used SQL003
					sql = "Select cv.mat_no pack_no, NULL mat_spec, NULL size, cv.in_qty qty, cv.in_wt wt, " +
						" NULL wh_code, NULL st_area ,'1' status From CS_Cover cv Where cv.in_flag = '*' " +
						" And cv.cancel_flag IS NULL And cv.out_flag IS NULL And cv.out_no IS NULL " +
						" And str(year(cv.in_date),4)+replace(str(month(cv.in_date),2),' ','0') <= '" +
						this.ddlYear.SelectedValue + "'+'" + this.ddlMonth.SelectedValue + "'" +//@p_year+@p_month
						" And cv.in_date <= convert(datetime,'" + 
						Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText) + "',20)" + //@p_do_date
						" Order By pack_no ";

					break;
				case 5://SCRAP used SQL004
					sql = "Select fg.pack_no, CASE fg.chgspec_flag WHEN '*' THEN fg.new_spec ELSE " +
						" (select m.mat_spec from CS_Material m where fg.mat_code = m.mat_code) END mat_spec " +
						" , CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END size " +
						" , fg.remain_qty qty, fg.remain_wt wt, fg.wh_code, fg.st_area, '1' status " +

						//17/06/2006 hong add this statement
						" , dbo.UTIL_CONVERT_NUMERIC( " +
						"       substring(substring( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ,charindex('X', " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       )+1,99),1,charindex('X',substring( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ,charindex('X', " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       )+1,99))-1) " +
						"    ) width " +
						" , dbo.UTIL_CONVERT_NUMERIC( " +
						"       reverse(substring(reverse( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ),1,charindex('X',reverse( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ))-1)) " +
						"    ) length " +

						" From CS_Finish_Goods fg Where fg.in_flag = '*' And fg.cancel_flag IS NULL " +
						" And fg.out_mc IS NULL And fg.out_flag IS NULL And fg.out_no IS NULL " +
						" And fg.pl_no IS NULL " +
						" And  " +
						" ( " ;
					//41SP   Scrap
					if (filter_type == "2")
						sql += "   (fg.in_type = 5 And (fg.grade IS NULL OR fg.grade = 'S')) " ;
					else
						sql += "   (SUBSTRING(fg.wh_code,3,5) IN ('SP')) " ;
					sql +=	" ) " +
						" And str(year(fg.in_date),4)+replace(str(month(fg.in_date),2),' ','0') <= '" +
						this.ddlYear.SelectedValue + "'+'" + this.ddlMonth.SelectedValue + "'" +  //@p_year+@p_month
						" And fg.in_date <= convert(datetime,'" + 
						Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText) + "',20)" + //@p_do_date
						" And ISNULL(fg.consign_flag,'') = ISNULL('" + consign + //@p_consign_flag
						"','') " ;
					if (order_type == "1")
						sql = sql + " Order By pack_no ";
					else //(order_type == "2")
						sql = sql + " Order By width, length, size ";

					break;
				case 6:// TOP/END used SQL005
					sql = "Select fg.pack_no, CASE fg.chgspec_flag WHEN '*' THEN fg.new_spec ELSE " +
						"(select m.mat_spec from CS_Material m where fg.mat_code = m.mat_code) END mat_spec " +
						", CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END size " +
						" , fg.remain_qty qty, fg.remain_wt wt, fg.wh_code, fg.st_area,'1' status " +

						//17/06/2006 hong add this statement
						" , dbo.UTIL_CONVERT_NUMERIC( " +
						"       substring(substring( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ,charindex('X', " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       )+1,99),1,charindex('X',substring( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ,charindex('X', " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       )+1,99))-1) " +
						"    ) width " +
						" , dbo.UTIL_CONVERT_NUMERIC( " +
						"       reverse(substring(reverse( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ),1,charindex('X',reverse( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ))-1)) " +
						"    ) length " +

						" From CS_Finish_Goods fg " +
						" Where fg.in_flag = '*' And fg.cancel_flag IS NULL And fg.out_mc IS NULL " +
						" And fg.out_flag IS NULL And fg.out_no IS NULL And fg.pl_no IS NULL " +
						" And  " +
						" ( " ;
					//41TE   Top/End
					if (filter_type == "2")
						sql += "   (fg.in_type = 7) " ;
					else
						sql += "   (SUBSTRING(fg.wh_code,3,5) IN ('TE')) " ;
					sql +=	" ) " +
						" And str(year(fg.in_date),4)+replace(str(month(fg.in_date),2),' ','0') <= '" +
						this.ddlYear.SelectedValue + "'+'" + this.ddlMonth.SelectedValue + "'" + //@p_year+@p_month
						" And fg.in_date <= convert(datetime,'" + 
						Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText) + "',20)" + //@p_do_date
						" And ISNULL(fg.consign_flag,'') = ISNULL('" + consign + //@p_consign_flag
						"','') ";
					if (order_type == "1")
						sql = sql + " Order By pack_no ";
					else //(order_type == "2")
						sql = sql + " Order By width, length, size ";

					break;
				case 7:// DEFECT used SQL008
					sql = " Select fg.pack_no "
						+ " , CASE fg.chgspec_flag WHEN '*' THEN fg.new_spec ELSE (select m.mat_spec from CS_Material m where fg.mat_code = m.mat_code) END mat_spec "
						+ " , CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END size "
						+ " , fg.remain_qty qty, fg.remain_wt wt, fg.wh_code, fg.st_area "
						+ " , '1' status "	+ // out of spec

						//17/06/2006 hong add this statement
						" , dbo.UTIL_CONVERT_NUMERIC( " +
						"       substring(substring( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ,charindex('X', " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       )+1,99),1,charindex('X',substring( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ,charindex('X', " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       )+1,99))-1) " +
						"    ) width " +
						" , dbo.UTIL_CONVERT_NUMERIC( " +
						"       reverse(substring(reverse( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ),1,charindex('X',reverse( " +
						"          (CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END) " +
						"       ))-1)) " +
						"    ) length " 

						+ " From CS_Finish_Goods fg "
						+ " Where fg.in_flag = '*' "
						+ " And fg.cancel_flag IS NULL "
						+ " And fg.out_mc IS NULL "
						+ " And fg.out_flag IS NULL "
						+ " And fg.out_no IS NULL "
						+ " And fg.pl_no IS NULL "
						+ " And  "
						+ " ( " ;
					//41C4   INSURANCE CLAIM (DEFECT)
					//41C5    (DEFECT)
					//09/10/2007 - Add wh-code C2C, C1D
					//13/02/2008 - Add wh-code DS
					//24/10/2008 - Add wh-code C2C , C2D , C2E , C1C 
					if (filter_type == "2")
						sql += "   (fg.in_type = 6) OR (fg.in_type = 5 AND fg.grade IN ('C','T')) " ;
					else
						sql += "   (SUBSTRING(fg.wh_code,3,5) IN ('C4','C5','C2C','C1D','DS','C2C','C2D','C2E','C1C')) " ;
					sql +=	" ) "
						+ " And str(year(fg.in_date),4)+replace(str(month(fg.in_date),2),' ','0') <= '" + this.ddlYear.SelectedValue + "'+'" + this.ddlMonth.SelectedValue + "'"
						+ " And fg.in_date <= convert(datetime,'" + Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText) + "',20) "
						+ " And ISNULL(fg.consign_flag,'') = ISNULL('" + consign + "','') ";
					if (order_type == "1")
						sql = sql + " Order By pack_no ";
					else //(order_type == "2")
						sql = sql + " Order By width, length, size ";

					break;
				default:
					sql = "";
					break;
			}// end switch
			DataTable dtsearch = Utility_Function.loadDb(sql);
			DataTable dt =FilterSearch(dtsearch);
			Session["dtSearch"]= dt; 
			Session["year"] = this.ddlYear.SelectedValue;
			Session["month"] = this.ddlMonth.SelectedValue;
			this.dgSearch.DataSource = dt;
			this.dgSearch.DataBind();
			this.lblSumWt.Text = "0 KGS.";
			if (msg)
				if (dt.Rows.Count ==0 )
					this.HidWarning.Value = " pack/math no";
		}

		private DataTable FilterSearch(DataTable dtsearch)
		{
			DataTable dtclone = dtsearch.Clone();
			DataTable dt;
			//Check duuplicate
			
			if (!this.btnSave.Enabled || Utility_Function.chkDBNull(Session["again"])== "Y")
			{
//				int no = 1;
				DataTable dtold = (DataTable)Session["dt"];//dgpackinglist
				for (int i = 0; i < dtsearch.Rows.Count; i++)
				{
					string result =CheckDataInDatagrid(dtold,dtsearch.Rows[i]["pack_no"].ToString());
					if (result == "")
					{
						try
						{
							DataRow dr = dtclone.NewRow();
//							dr["No"] = no;
//							no = no + 1;
							dr["pack_no"] = dtsearch.Rows[i]["pack_no"].ToString();

							//23/05/2006 hong add this statement
							//dr["mat_spec"]= dtsearch.Rows[i]["mat_spec"].ToString();
							if (Utility_Function.chkDBNull(dtsearch.Rows[i]["mat_spec"].ToString())== "")
								dr["mat_spec"]= System.DBNull.Value;
							else	
								dr["mat_spec"]= dtsearch.Rows[i]["mat_spec"].ToString();

							if (Utility_Function.chkDBNull(dtsearch.Rows[i]["size"].ToString())== "")
								dr["size"]= System.DBNull.Value;
							else	
								dr["size"]= dtsearch.Rows[i]["size"].ToString();

							if (Utility_Function.chkDBNull(dtsearch.Rows[i]["qty"].ToString())== "")
								dr["qty"]= System.DBNull.Value;
							else	
								dr["qty"]= dtsearch.Rows[i]["qty"].ToString();

							if (Utility_Function.chkDBNull(dtsearch.Rows[i]["wt"].ToString())== "")
								dr["wt"]= System.DBNull.Value;
							else							
								dr["wt"]= dtsearch.Rows[i]["wt"].ToString();

							//dr["wh_code"]= Utility_Function.chkDBNull(dtsearch.Rows[i]["wh_code"].ToString());
							if (Utility_Function.chkDBNull(dtsearch.Rows[i]["wh_code"].ToString())== "")
								dr["wh_code"]= System.DBNull.Value;
							else							
								dr["wh_code"]= dtsearch.Rows[i]["wh_code"].ToString();

							//dr["st_area"]= Utility_Function.chkDBNull(dtsearch.Rows[i]["st_area"].ToString());
							if (Utility_Function.chkDBNull(dtsearch.Rows[i]["st_area"].ToString())== "")
								dr["st_area"]= System.DBNull.Value;
							else							
								dr["st_area"]= dtsearch.Rows[i]["st_area"].ToString();

							dr["status"]= dtsearch.Rows[i]["status"].ToString();
							dtclone.Rows.Add (dr);
						}
						catch (Exception ex)
						{
							this.HidWarning.Value = ex.ToString();
						}
					}
				}//for	
				dt = dtclone.Copy();
			}
			else
				dt = dtsearch.Copy();

			return dt;
		}
		#endregion

		#region Add pack/math no

		private void AddPack_Math()
		{//bind dgpackinglist
			DataTable dt = new DataTable();
			string err = "";
			DataRow dr;
			int no;
			if (this.btnSave.Enabled)
			{
				if (Utility_Function.chkDBNull(Session["again"])== "Y")
				{
					dt = (DataTable)Session["dt"];
					no= this.dgPacklist.Items.Count;

				}
				else
				{
					dt = CreateStructDT();
					no= 0;	
					Session["again"]= "Y";
				}
			}
			else
			{
				dt = (DataTable)Session["dt"];
				no= this.dgPacklist.Items.Count;
			}
			for (int i = 0; i < this.dgSearch.Items.Count; i++)
			{
				CheckBox ch = new CheckBox();
				ch = (CheckBox) dgSearch.Items[i].Cells[(int) myDGColumn.No].Controls[1];
				if (ch.Checked)
				{
					TextBox data = new TextBox();
					data = (TextBox) dgSearch.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					string chdup = CheckDataInDatagrid(dt,data.Text);
					if (chdup != "")
						err = err + chdup;
					else
					{
						no = no + 1;
						dr = dt.NewRow();
						dr["No"] = no.ToString();
						dr["pack_no"] = data.Text;
						data = (TextBox) dgSearch.Items[i].Cells[(int) myDGColumn.Spec].Controls[1];
						dr["mat_spec"]= data.Text;
						data = (TextBox) dgSearch.Items[i].Cells[(int) myDGColumn.Size].Controls[1];
						dr["size"]= data.Text;
						data = (TextBox) dgSearch.Items[i].Cells[(int) myDGColumn.Qty].Controls[1];
						dr["qty"]= data.Text;
						data = (TextBox) dgSearch.Items[i].Cells[(int) myDGColumn.Weight].Controls[1];
						dr["wt"]= data.Text;
						data = (TextBox) dgSearch.Items[i].Cells[(int) myDGColumn.WH].Controls[1];
						dr["wh_code"]= data.Text;
						data = (TextBox) dgSearch.Items[i].Cells[(int) myDGColumn.ST].Controls[1];
						dr["st_area"]= data.Text;
						dr["status"]="1";
						dt.Rows.Add (dr);
					}
				}//if (ch.Checked)
			}//end for
			Session["dt"]= dt;
			this.lblTotalWeight.Text = "0";
			this.lblQty.Text = "0";
			this.dgPacklist.DataSource= dt;
			this.dgPacklist.DataBind();
			SearchPack_Math(false);
			if (err != "")
				this.HidWarning.Value = err;
		}

		private string CheckDataInDatagrid(DataTable dt,string packno_new)
		{
			string err = "";
			bool ch = true;
			for (int i=0; i<dt.Rows.Count; i++)
			{
				string packno_old =dt.Rows[i]["pack_no"].ToString();
				if (packno_old != "")
				{
					if (ch)
                    	if (packno_new == packno_old)
						{
							err = "Pack/Math No " + packno_new + " \n";
							ch = false;
						}
				}//if (packno_old != "")
			}
			return err;
		}
		#endregion

		#region Search D/O No
		private void QueryDONo()
		{
			string pl_type =this.rdbType.SelectedValue.ToString();
			//SQL001
			sql = "Select d.do_no, convert(varchar(10),d.do_date,20) do_date, d.contract_no, d.order_no " +
				", c.credit term, convert(varchar(10),d.due_date,20) due_date, d.consign_flag " +
				", d.cust_code, c.cust_name, c.address1, c.address2, d.comm_id, d.lot_desc, d.group_no, d.total_wt, d.adjust_wt " +
				", d.net_wt, d.gross_wt, d.remarks From CS_Do d, CS_Customer c Where d.cust_code = c.cust_code " +
				" And d.cancel_flag IS NULL And d.do_type = " + pl_type + //@p_do_type
				" And d.do_no = '" + this.txtDONo.Text + "'"; // @p_do_no

			DataTable dt = Utility_Function.loadDb(sql);
			if(dt.Rows.Count > 0)
			{
				this.txtDONo.Text  = dt.Rows[0]["do_no"].ToString();
				this.DPIDate.DateText =Date_Function.ConvertDate_Dash2Slash(dt.Rows[0]["do_date"].ToString());
				this.txtDueDate.Text =Date_Function.ConvertDate_Dash2Slash(dt.Rows[0]["due_date"].ToString());
				this.txtContractNo.Text =dt.Rows[0]["contract_no"].ToString();
				this.txtOrderNo.Text =dt.Rows[0]["order_no"].ToString();
				this.txtTerm.Text =dt.Rows[0]["term"].ToString();
				this.lblCustName.Text =dt.Rows[0]["cust_name"].ToString();
				this.txtCustcode.Text =dt.Rows[0]["cust_code"].ToString();
				CheckListCommodityDdl(this.txtCustcode.Text);
				this.lbAddress1.Text = dt.Rows[0]["address1"].ToString ();
				this.lbAddress2.Text= dt.Rows[0]["address2"].ToString ();
				string consign = Utility_Function.chkDBNull( dt.Rows[0]["consign_flag"].ToString());
				if (consign == "*")
					this.chConsign.Checked = true;
				else
					this.chConsign.Checked = false;

				if (this.ddlComm.Items.FindByValue(dt.Rows[0]["comm_id"].ToString()) == null) 
				{
					this.HidWarning.Value="Commodity ١¡ԡ";
					this.ddlComm.SelectedIndex = 0;
				}
				else 
				{
					this.ddlComm.SelectedValue = Utility_Function.chkDBNull_ReturnNull(dt.Rows[0]["comm_id"].ToString ());
				}
				this.LotTbx.Text = dt.Rows[0]["lot_desc"].ToString ();
				this.ddlGroupNo.SelectedValue = (dt.Rows[0]["group_no"].ToString()=="" ? "1" : dt.Rows[0]["group_no"].ToString());
				this.txttotalWeight.Text = dt.Rows[0]["total_wt"].ToString ();
				this.txtAdjust.Text = dt.Rows[0]["adjust_wt"].ToString ();
				this.txtNetWeight.Text = dt.Rows[0]["net_wt"].ToString ();
				this.txtGrossWeight.Text = dt.Rows[0]["gross_wt"].ToString ();
				this.txtRemark.Text = dt.Rows[0]["remarks"].ToString ();
				setButton(false,true);
				BinddgPackinglist();
				this.WarningLbl.Text = "";
				setToUpdate(false);
				CheckCanUpdate();
			}
			else
			{
				this.HidWarning.Value="辺 D/O No";
				this.SetClearPage(false); 
				setToUpdate(true);
				setButton(true,false);
				GUI_Function.SetFocus(this.txtDONo);
			}
		}

		private void BinddgPackinglist()
		{
			this.lblTotalWeight.Text = "0";
			this.lblQty.Text = "0";
			string sql;
			string pl_type =this.rdbType.SelectedValue.ToString();
			//SQL002
			sql = " Select di.do_no, di.item "
				+ " , di.pack_no, (select mat_spec from cs_material where mat_code = di.mat_code) mat_spec "
				+ " , di.size, di.do_qty qty, di.do_wt wt "
				+ " , A.wh_code, A.st_area "
				+ " , '2' status "	// out of spec
				+ " From CS_DO_Item di "
				+ " , ( "
				+ "    Select 4 do_type, mat_no pack_no, NULL wh_code, NULL st_area, out_comm_id comm_id From CS_Cover Where out_no='" + this.txtDONo.Text.Trim() + "'"
				+ "    UNION "
				+ "    Select 5 do_type, pack_no pack_no, wh_code, st_area, out_comm_id comm_id From CS_Finish_Goods Where out_no='" + this.txtDONo.Text.Trim() + "'"
				+ "    UNION "
				+ "    Select 6 do_type, pack_no pack_no, wh_code, st_area, out_comm_id comm_id From CS_Finish_Goods Where out_no='" + this.txtDONo.Text.Trim() + "'"
				+ "    UNION "
				+ "    Select 7 do_type, pack_no pack_no, wh_code, st_area, out_comm_id comm_id From CS_Finish_Goods Where out_no='" + this.txtDONo.Text.Trim() + "'"
				+ " ) A "
				+ " Where di.cancel_flag IS NULL "
				+ " And di.pack_no = A.pack_no "
				+ " And A.do_type = " + pl_type
				+ " And di.do_no = '" + this.txtDONo.Text.Trim() + "'"
				+ " Order By di.item ";

			DataTable dt = Utility_Function.loadDb(sql);
			dt.Columns.Add ("No");
//			DataRow dr;
			for (int i = 0; i < dt.Rows.Count; i++)
			{
//				if (i > dt.Rows.Count-1 )
//				{
//					dr = dt.NewRow();
//					dr["No"] = i + 1;
//					dt.Rows.Add (dr);
//				}
//				else
					dt.Rows[i]["No"] = i+1;
			}
			Session["dt"]= dt; 
			dgPacklist.DataSource = dt.DefaultView;
			dgPacklist.DataBind();
		}

		private void CheckCanUpdate()
		{
			//SQL006
			sql = "d.do_flag IS NULL And d.inv_flag IS NULL And d.pkl_inv_no IS NULL " +
				" And d.do_no = '" + this.txtDONo.Text.Trim() + "'" +  //@p_do_no
				" And d.do_type = " + this.rdbType.SelectedValue ; //@p_do_type

			string condi = Utility_Function.GetValueDB("CASE WHEN count(*)=0 THEN 'DENY' ELSE 'ALLOW' END ", 
				"CS_Do d",sql).ToString();
			if (condi =="DENY")
				setButton(false,false);
			else
				setButton(false,true);

		}
		#endregion

		#region Extra funtion

		private void setButton(bool btSave,bool btUpdate)
		{
			this.btnSave.Enabled = btSave;
			this.btnUpdate.Enabled = btUpdate;
		}

		private void CalDueDate(bool setfocus)
		{
			try
			{
				string term = this.txtTerm.Text.Trim();
				this.txtDueDate.Text = "";
				if (this.DPIDate.DateText == "")
				{
					this.HidWarning.Value = " D/O Date ó.";
					GUI_Function.UC_SetFocus(this.DPIDate,"DateTbx");
				}
				else if (term == "")
				{
					this.HidWarning.Value = " Term(days) ó.";
					if (setfocus)
						GUI_Function.SetFocus(this.txtTerm);
				}
				else
				{
					CultureInfo culture = new CultureInfo("fr-FR", true);
					DateTime doDate = DateTime.Parse(this.DPIDate.DateText,culture);
					Session["date"]= this.DPIDate.DateText;
					Session["duedate"] = this.txtDueDate.Text = doDate.AddDays(Convert.ToInt64(term)).ToString("dd/MM/yyyy");
					if (setfocus)
						GUI_Function.SetFocus(this.txtCustcode);
 				}
			}
			catch 
			{
				this.HidWarning.Value = "Term ͧ繵Ţҹ";	
				this.txtTerm.Text = "0";
				GUI_Function.SetFocus(this.txtTerm);
				this.txtDueDate.Text = this.DPIDate.DateText;

			}
		}
		private void setToUpdate(bool enable)
		{
			this.DPIDate.Enabled =  enable;
			//this.txtDONo.Enabled = enable;
			this.txtContractNo.Enabled  = enable;
			this.txtOrderNo.Enabled =enable;
			this.txtCustcode.Enabled = enable;
			this.chConsign.Enabled= enable;
			this.txtContractNo.Enabled= enable;
			this.ddlComm.Enabled= enable;

		}
		#endregion

		#region Check data complete

		private bool Checkdata()
		{
			string msg = "";
			bool ch = true;
			if (this.txtOrderNo.Text.Trim() == "")
			{
				ch = ch & false;
				msg = msg + "Order No  \n";
				GUI_Function.SetFocus(this.txtOrderNo);	
			}
			if (this.txtContractNo.Text.Trim() == "")
			{
				ch = ch & false;
				msg = msg + "Contract No  \n";
				GUI_Function.SetFocus(this.txtContractNo);	
			}
			if (this.txtCustcode.Text  == "")
			{
				ch = ch & false;
				msg = msg + "Cust code  \n";
				GUI_Function.SetFocus(this.txtCustcode);	
			}

			if (this.txtGrossWeight.Text.Trim() == "")
			{
				ch = ch & false;
				msg = msg + "Gross Weight \n";
				GUI_Function.SetFocus(this.txtGrossWeight);	
			}
			if (this.txtNetWeight.Text.Trim() == "")
			{
				ch = ch & false;
				msg = msg + "Net Weight  \n";
				GUI_Function.SetFocus(this.txtNetWeight);	
			}
			if (this.ddlComm.SelectedValue == "NULL")
			{
				ch = ch & false;
				msg = msg + "Commodity  \n";
				GUI_Function.SetFocus(this.ddlComm);	
			}
			if (this.LotTbx.Text.Trim() == "")
			{
				ch = ch & false;
				msg = msg + "Lot Description  \n";
				GUI_Function.SetFocus(this.LotTbx);	
			}
			if (msg != "")
				msg = "سҡ͡ :" + msg;

			try
			{
				if (Double.Parse(this.txtNetWeight.Text) <= 0)
				{
					ch = ch & false;
					msg = msg + "Net Weight ͧҡҡѺٹ\n";
					GUI_Function.SetFocus(this.txtNetWeight);
				}
				if (Double.Parse(this.txtGrossWeight.Text) <= 0)
				{
					ch = ch & false;
					msg = msg + "Gross Weight ͧҡҡѺٹ\n";
					GUI_Function.SetFocus(this.txtGrossWeight);
				}
				if (Double.Parse(this.txtGrossWeight.Text) < Double.Parse(this.txtNetWeight.Text))
				{
					ch = ch & false;
					msg = msg + "Gross Weight ͧҡҡѺ Net Weight  \n";
					GUI_Function.SetFocus(this.txtGrossWeight);
				}
				if (Double.Parse(this.txtAdjust.Text) != Double.Parse(this.txtNetWeight.Text) - Double.Parse(this.txttotalWeight.Text))
				{
					ch = ch & false;
					double adjust = Double.Parse(this.txtNetWeight.Text) - Double.Parse(this.txttotalWeight.Text);
					this.txtAdjust.Text= adjust.ToString();
					msg = msg + "Adjust Weight ͧҡѺ  Net Weight - Total Weight \n";
					GUI_Function.SetFocus(this.txtNetWeight);
				}
			}
			catch
			{
				this.HidWarning.Value = "Gross Weight ,Net Weight ͧ繵Ţҹ";	
				this.txtGrossWeight.Text = this.txtNetWeight.Text;
				GUI_Function.SetFocus(this.txtGrossWeight);
				ch = ch & false;

			}			
			if (this.dgPacklist.Items.Count < 1 )
			{
				msg = msg + "س͡ Pack/Math no";
				ch = ch & false;
			}
			this.HidWarning.Value = msg;
			return ch;
		}

		#endregion

		#region Action Button

		private void Logout_Btn_Click(object sender, System.EventArgs e)
		{
			Session["LoggedIn"] = "no";
			Session["username"] = "";
			Session.Clear();
			FormsAuthentication.SignOut();
			Response.Write("<script>parent.window.location.replace(\"../LoginForm.aspx\");</script>");

		}

		private void btnsearch_Click(object sender, System.EventArgs e)
		{
			SearchPack_Math(true);
		}

		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			AddPack_Math();
		}
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			if (this.Checkdata())
				InsertDB();
		}

		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			if (this.Checkdata())
				UpdateDB();
		}

		private void btnClear_Click(object sender, System.EventArgs e)
		{
			SetClearPage(false);
			this.UnLockLocation();
		}

		#endregion

		#region Action Radiobutton and checkbox

		private void rdbType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			SetClearPage(false);
			Session["type"]= this.rdbType.SelectedIndex.ToString();
		}

		private void chConsign_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BindGrid();
			ClearSearch(); //SearchPack_Math(false);
			Session["again"]= "N";
			this.GUI_Function.SetFocus(this.txtCustcode);
		}

		#endregion

		#region Action Textbox

		private void txtCustcode_TextChanged(object sender, System.EventArgs e)
		{
			QueryCustCode();
			CheckListCommodityDdl(this.txtCustcode.Text);
			ClearSearch(); //SearchPack_Math(false);
			Session["again"]= "N";
			GUI_Function.SetFocus(this.ddlComm);
		}

		private void txtGrossWeight_TextChanged(object sender, System.EventArgs e)
		{
			GUI_Function.LockLocation(this, "LOCATION_DETAIL");
			try
			{
				if (this.txtGrossWeight.Text.IndexOf(".") != -1 || this.txtGrossWeight.Text.IndexOf("-") != -1
					|| this.txtGrossWeight.Text == "0")
				{
					this.HidWarning.Value = "Gross Weight ͧ繨ӹǹ Դź ٹ";
					GUI_Function.SetFocus(this.txtGrossWeight);
				}
				else if (Double.Parse(this.txtGrossWeight.Text) < Double.Parse(this.txtNetWeight.Text))
				{
					this.HidWarning.Value = "Gross Weight ͧҡҡѺ Net Weight";	
					this.txtGrossWeight.Text= this.txtNetWeight.Text;
					GUI_Function.SetFocus(this.txtGrossWeight);

				}
				else
					GUI_Function.SetFocus(this.txtRemark);
			}
			catch
			{
				this.HidWarning.Value = "Gross Weight ͧ繵Ţҹ";	
				this.txtGrossWeight.Text = this.txtNetWeight.Text;
				GUI_Function.SetFocus(this.txtGrossWeight);

			}
		}

		private void txtNetWeight_TextChanged(object sender, System.EventArgs e)
		{
			GUI_Function.LockLocation(this, "LOCATION_DETAIL");

			//Adjust Weight = Net Weight - Total Weight
			try
			{
				if (this.txtNetWeight.Text.IndexOf(".") != -1 || this.txtNetWeight.Text.IndexOf("-") != -1
					|| this.txtNetWeight.Text == "0")
				{
					this.HidWarning.Value = "Net Weight ͧ繨ӹǹ Դź ٹ";
					GUI_Function.SetFocus(this.txtNetWeight);
				}
				else
				{
					double adjust = Double.Parse(this.txtNetWeight.Text) - Double.Parse(this.txttotalWeight.Text);
					this.txtAdjust.Text= adjust.ToString();
					txtGrossWeight.Text= this.txtNetWeight.Text;
					GUI_Function.SetFocus(this.txtGrossWeight);
				}
			}
			catch
			{
				this.HidWarning.Value = "Net Weight ͧ繵Ţҹ";	
				this.txtNetWeight.Text= this.lblTotalWeight.Text ;
				this.txtAdjust.Text = "0";
				GUI_Function.SetFocus(this.txtNetWeight);

			}
		}

		private void txtDONo_TextChanged(object sender, System.EventArgs e)
		{
			QueryDONo();
			ClearSearch(); //SearchPack_Math(false);
		}
		#endregion

		#region Action Date

		private void DPIDate_onHideCalendar(object sender, System.EventArgs e) 
		{
			this.ddlComm.Visible = true;
		}

		private void DPIDate_onShowCalendar(object sender, System.EventArgs e) 
		{
			this.ddlComm.Visible = false;
		}

		private void DPIDate_DateChanged(object sender, System.EventArgs e) 
		{
			this.BindGrid();
			ClearSearch(); //SearchPack_Math(false);
			Session["again"]= "N";
			CalDueDate(false);
			GUI_Function.SetFocus(this.txtContractNo);
		}
		#endregion

		#region Action Dropdown list

		private void ddlComm_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Session["ddlcomm"] = this.ddlComm.SelectedValue;
			GUI_Function.SetFocus(this.LotTbx);
		}
		#endregion

		#region Transaction

		private bool InsertDB()
		{
			//23/05/2006 hong add transaction
			SqlTransaction trans = null;

			try
			{
				string err = "";
				sqlconn.Open();
				trans = sqlconn.BeginTransaction();
				SqlCommand cmd = sqlconn.CreateCommand();
				cmd.Transaction = trans;
				cmd.CommandText = "CSFZ21_1_PROC001";
				cmd.CommandType = CommandType.StoredProcedure;
				cmd.Parameters.Add (new SqlParameter("@p_do_type", this.rdbType.SelectedValue.ToString() ));
				cmd.Parameters.Add (new SqlParameter("@p_do_date", Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText)));
				cmd.Parameters.Add (new SqlParameter("@p_contract_no", this.txtContractNo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_order_no", this.txtOrderNo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_due_date", Date_Function.ConvertDate_Slash2Dash(this.txtDueDate.Text)));
				if (this.chConsign.Checked)
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", "*"));
				else
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", DBNull.Value));
				cmd.Parameters.Add (new SqlParameter("@p_cust_code", this.txtCustcode.Text));
				cmd.Parameters.Add (new SqlParameter("@p_comm_id", this.ddlComm.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_lot_desc", this.LotTbx.Text));
				cmd.Parameters.Add (new SqlParameter("@p_group_no", this.ddlGroupNo.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_total_wt", this.lblTotalWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_adjust_wt", this.txtAdjust.Text));
				cmd.Parameters.Add (new SqlParameter("@p_net_wt", this.txtNetWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_gross_wt", this.txtGrossWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_remark", this.txtRemark.Text.Trim()));
				cmd.Parameters.Add (new SqlParameter("@p_user_id", Session["username"].ToString()));
				SqlParameter sampParm = cmd.Parameters.Add("@out_do_no", SqlDbType.VarChar,255);
				sampParm.Direction = ParameterDirection.Output;

				object o = cmd.ExecuteScalar();
				this.txtDONo.Text = sampParm.Value.ToString();
				for (int i = 0; i < this.dgPacklist.Items.Count; i++)
				{
					TextBox P_MNo = new TextBox();
					P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					if (P_MNo.Text != "")
					{
						HidWarning.Value = "";
						ModifyPackno(P_MNo.Text, trans);
						if (HidWarning.Value != "")
							err = err + HidWarning.Value;
					}
				}
				trans.Commit();
				sqlconn.Close();

				QueryDONo();
				if (err !="")
					this.HidWarning.Value=err;
				else	
					this.HidWarning.Value="SAVEBTN_COMPLETE";
				return true;
			}
			catch (SqlException e) 
			{
				if (trans != null)
				{
					trans.Rollback();
					sqlconn.Close();
				}
				string errorMessages = "";
				for (int i=0; i < e.Errors.Count; i++)
				{
					errorMessages += "Message: " + e.Errors[i].Message + "\n" ;
				}
				HidWarning.Value=errorMessages;
				return false;
			}

		}

		private bool ModifyPackno(string packno, SqlTransaction trans)
		{
//			try
//			{
				SqlCommand cmd = sqlconn.CreateCommand();
				cmd.Transaction = trans;
				cmd.CommandText = "CSFZ21_1_PROC002";
				cmd.CommandType = CommandType.StoredProcedure;
				cmd.Parameters.Add (new SqlParameter("@p_do_type", this.rdbType.SelectedValue.ToString() ));
				cmd.Parameters.Add (new SqlParameter("@p_do_no", this.txtDONo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_do_date", Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText)));
				cmd.Parameters.Add (new SqlParameter("@p_comm_id",this.ddlComm.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_pack_no", packno));
				cmd.Parameters.Add (new SqlParameter("@p_user_id", Session["username"].ToString()));
				cmd.ExecuteNonQuery();
				return true;
//			}
//			catch (SqlException e) 
//			{
//				string errorMessages = "";
//				for (int i=0; i < e.Errors.Count; i++)
//				{
//					errorMessages += "Message: " + e.Errors[i].Message + "\n" ;
//				}
//				HidWarning.Value=errorMessages;
//				return false;
//			}
		}
		private bool UpdateDB()
		{
			//23/05/2006 hong add transaction
			SqlTransaction trans = null;

			try
			{
				string err = "";
				sqlconn.Open();
				trans = sqlconn.BeginTransaction();
				SqlCommand cmd = sqlconn.CreateCommand();
				cmd.Transaction = trans;
				cmd.CommandText = "CSFZ21_1_PROC003";
				cmd.CommandType = CommandType.StoredProcedure;
				cmd.Parameters.Add (new SqlParameter("@p_do_type", this.rdbType.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_do_no", this.txtDONo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_do_date", Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText)));
				cmd.Parameters.Add (new SqlParameter("@p_contract_no", this.txtContractNo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_order_no", this.txtOrderNo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_due_date", Date_Function.ConvertDate_Slash2Dash(this.txtDueDate.Text )));
				if (this.chConsign.Checked)
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", "*"));
				else
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", DBNull.Value));
				cmd.Parameters.Add (new SqlParameter("@p_cust_code", this.txtCustcode.Text));
				cmd.Parameters.Add (new SqlParameter("@p_comm_id", this.ddlComm.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_lot_desc", this.LotTbx.Text));
				cmd.Parameters.Add (new SqlParameter("@p_group_no", this.ddlGroupNo.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_total_wt", this.lblTotalWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_adjust_wt", this.txtAdjust.Text));
				cmd.Parameters.Add (new SqlParameter("@p_net_wt", this.txtNetWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_gross_wt", this.txtGrossWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_remark", this.txtRemark.Text));
				cmd.Parameters.Add (new SqlParameter("@p_user_id", Session["username"].ToString()));
				cmd.ExecuteNonQuery();
				for (int i = 0; i < this.dgPacklist.Items.Count; i++)
				{
					TextBox P_MNo = new TextBox();
					P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					string status = this.dgPacklist.Items[i].Cells[(int) myDGColumn.status].Text;
					if (P_MNo.Text != "" & status == "1")
					{
						HidWarning.Value = "";
						ModifyPackno(P_MNo.Text, trans);
						if (HidWarning.Value != "")
							err = err + HidWarning.Value;
					}
				}
				trans.Commit();
				sqlconn.Close();
				QueryDONo();
				if (err !="")
					this.HidWarning.Value=err;
				else	
					this.HidWarning.Value="SAVEBTN_COMPLETE";
				return true;
			}
			catch (SqlException e) 
			{
				if (trans != null)
				{
					trans.Rollback();
					sqlconn.Close();
				}
				string errorMessages = "";
				for (int i=0; i < e.Errors.Count; i++)
				{
					errorMessages += "Message: " + e.Errors[i].Message + "\n" ;
				}
				HidWarning.Value=errorMessages;
				return false;
			}
		}
		#endregion

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
			if (this.txtDONo.Text.Trim() == "") return;

			string user, password, server, database;
			user = System.Configuration.ConfigurationSettings.AppSettings["User"].ToString();
			password = System.Configuration.ConfigurationSettings.AppSettings["Password"].ToString();
			server = System.Configuration.ConfigurationSettings.AppSettings["Server"].ToString();
			database = System.Configuration.ConfigurationSettings.AppSettings["Database"].ToString();

			string[] param = new string[2];
			param[0] = this.txtDONo.Text.Trim();
			param[1] = this.txtDONo.Text.Trim();
			GeneratePDF.generate_pdf Rpt = new GeneratePDF.generate_pdf(server,database,user,password);
			if (this.rdbType.SelectedValue == "4")	//--Cover
				Rpt.CreateReport("CSP21_HL.rpt",param,"PDF");
			else if (this.rdbType.SelectedValue == "5")	//--Scrap
				Rpt.CreateReport("CSP21_HL.rpt",param,"PDF");
			else if (this.rdbType.SelectedValue == "6")	//--Top/End
				Rpt.CreateReport("CSP21_HL.rpt",param,"PDF");
			else if (this.rdbType.SelectedValue == "7")	//--Defect
				Rpt.CreateReport("CSP21_HL.rpt",param,"PDF");
			else	//--N/A
				Rpt.CreateReport("CSP21_HL.rpt",param,"PDF");
		}

		private void btnPrint2_Click(object sender, System.EventArgs e)
		{
			if (this.txtDONo.Text.Trim() == "") return;

			string user, password, server, database;
			user = System.Configuration.ConfigurationSettings.AppSettings["User"].ToString();
			password = System.Configuration.ConfigurationSettings.AppSettings["Password"].ToString();
			server = System.Configuration.ConfigurationSettings.AppSettings["Server"].ToString();
			database = System.Configuration.ConfigurationSettings.AppSettings["Database"].ToString();

			string[] param = new string[2];
			param[0] = this.txtDONo.Text.Trim();
			param[1] = this.txtDONo.Text.Trim();
			GeneratePDF.generate_pdf Rpt = new GeneratePDF.generate_pdf(server,database,user,password);
			if (this.rdbType.SelectedValue == "4")	//--Cover
				Rpt.CreateReport("CSP21_ML.rpt",param,"PDF");
			else if (this.rdbType.SelectedValue == "5")	//--Scrap
				Rpt.CreateReport("CSP21_ML.rpt",param,"PDF");
			else if (this.rdbType.SelectedValue == "6")	//--Top/End
				Rpt.CreateReport("CSP21_ML.rpt",param,"PDF");
			else if (this.rdbType.SelectedValue == "7")	//--Defect
				Rpt.CreateReport("CSP21_ML.rpt",param,"PDF");
			else	//--N/A
				Rpt.CreateReport("CSP21_ML.rpt",param,"PDF");
		}

		private void btnSumWt_Click(object sender, System.EventArgs e)
		{
			CheckBox chk;
			TextBox tbx;
			DataGridItem item;
			double sumwt=0;

			for (int i=0 ; i<dgSearch.Items.Count ; ++i)
			{
				item = dgSearch.Items[i];
				chk = (CheckBox) item.Cells[0].Controls[1];
				tbx = (TextBox) item.Cells[5].Controls[1];
				if (chk.Checked)
				{
					try
					{
						sumwt += Double.Parse(tbx.Text);
					}
					catch
					{
						sumwt += 0;
					}
				}
			}
			this.lblSumWt.Text = sumwt.ToString("###0") + " KGS.";
		}

	}// end class
}//end namespace
